import config
import anthropic
import os
import re
from time import sleep

from tenacity import (
    retry,
    stop_after_attempt,
    wait_random_exponential,
)

api_key = os.environ.get("ANTHROPIC_API_KEY")
if (api_key is None or api_key == "") and os.path.isfile(os.path.join(os.getcwd(), "keys.cfg")):
    cfg = config.Config('keys.cfg')
    api_key = cfg.get("ANTHROPIC_API_KEY")
client = anthropic.Client(api_key=api_key)

# Define retry decorator to handle OpenAI API timeouts
@retry(wait=wait_random_exponential(min=1, max=60), stop=stop_after_attempt(6))
def chat_with_backoff(**kwargs):
    return client.messages.create(**kwargs)

# Define GPT-3.5+ chat function
def Claude(messages, model="claude-3-opus-20240229", num_samples=1):
    try:
        response = chat_with_backoff(
            model=model,
            system=messages[0]['content'], # <-- system prompt
            messages=messages[1:],
            max_tokens=4095,
            temperature=0,
            top_p=1
        )
    except:
        print(messages[1:])
        fuck

    return response.content[0].text

if __name__ == "__main__":
    pass